import React from "react";
import { cn } from "@/lib/utils";

interface InputProps extends React.InputHTMLAttributes<HTMLInputElement> {
  label?: string;
  error?: string;
}

export function Input({ label, error, className, ...props }: InputProps) {
  return (
    <div className="w-full">
      {label && (
        <label className="block font-medium text-[#15364d] mb-2">
          {label}
          {props.required && <span className="text-red-500 ml-1">*</span>}
        </label>
      )}
      <input
        className={cn(
          "w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-[#15364d] focus:border-transparent transition-all outline-none",
          error ? "border-red-500" : "border-gray-300",
          props.readOnly && "bg-gray-100 cursor-not-allowed",
          className
        )}
        {...props}
      />
      {error && <p className="mt-1 text-sm text-red-500">{error}</p>}
    </div>
  );
}
