import { Github, Linkedin, Mail } from "lucide-react";
import Link from "next/link";

interface FooterProps {
  personal: any;
}

export function Footer({ personal }: FooterProps) {
  const currentYear = new Date().getFullYear();

  return (
    <footer className="border-t border-border bg-white py-6 px-4 overflow-x-hidden">
      <div className="max-w-6xl mx-auto flex flex-col items-center gap-4">
        {/* Logo on top */}
        <Link href="https://nasrcodes.dev" target="_blank" className="mb-2">
          <img
            src="https://edu.nasrcodes.dev/footer-logo.png"
            alt="NasrCodes Logo"
            className="w-50 h-auto"
          />
        </Link>

        {/* Copyright */}
        <p className="text-[#15364d] text-sm text-center" dir="ltr">
          © {currentYear} NasrCodes for Technology. All rights reserved.
        </p>

        {/* Social */}
        <div className="flex gap-6">
          <a
            href={`https://${personal.github}`}
            target="_blank"
            rel="noopener noreferrer"
            className="text-[#15364d] hover:text-accent transition-colors duration-300"
            aria-label="GitHub"
          >
            <Github className="w-5 h-5" />
          </a>
          <a
            href={`https://${personal.linkedin}`}
            target="_blank"
            rel="noopener noreferrer"
            className="text-[#15364d] hover:text-accent transition-colors duration-300"
            aria-label="LinkedIn"
          >
            <Linkedin className="w-5 h-5" />
          </a>
          <a
            href={`mailto:${personal.email}`}
            className="text-[#15364d] hover:text-accent transition-colors duration-300"
            aria-label="Email"
          >
            <Mail className="w-5 h-5" />
          </a>
        </div>
      </div>
    </footer>
  );
}
