import { MetadataRoute } from "next";

const DOMAIN = process.env.NEXT_PUBLIC_DOMAIN || "https://your-domain.com";

export default function sitemap(): MetadataRoute.Sitemap {
  const routes = [
    "",
    "/login",
    "/dashboard",
    "/dashboard/exam",
    "/dashboard/profile",
    "/judge",
    "/judge/evaluation-sheets",
    "/judge/evaluations",
    "/judge/users",
    "/admin",
    "/admin/categories",
    "/admin/countries",
    "/admin/governorates",
    "/admin/languages",
    "/admin/exams",
    "/admin/evaluation-sheets",
    "/admin/logs",
    "/admin/settings",
    "/admin/users",
  ];

  return routes.map((route) => ({
    url: `${DOMAIN}${route}`,
    lastModified: new Date(),
    changeFrequency: "weekly" as const,
    priority: route === "" ? 1 : 0.8,
  }));
}
