import { MetadataRoute } from "next";

export default function robots(): MetadataRoute.Robots {
  return {
    rules: [
      {
        userAgent: "*",
        allow: "/",
        disallow: [
          "/admin",
          "/judge",
          "/dashboard",
          "/login",
          "/unauthorized",
          "/maintenance",
          "/*.json$",
          "/.env",
        ],
        crawlDelay: 1,
      },
      {
        userAgent: "Googlebot",
        allow: "/",
      },
      {
        userAgent: "Bingbot",
        allow: "/",
      },
    ],
    sitemap: `${
      process.env.NEXT_PUBLIC_DOMAIN || "https://your-domain.com"
    }/sitemap.xml`,
  };
}
