"use client";

import { ReactNode } from "react";
import { ProtectedRoute } from "@/components/shared/ProtectedRoute";
import { Sidebar } from "@/components/shared/Sidebar";

export default function AdminLayout({ children }: { children: ReactNode }) {
  return (
    <ProtectedRoute allowedRoles={["admin"]}>
      <div className="flex min-h-screen bg-gray-50" dir="rtl">
        <Sidebar role="admin" />
        <main className="flex-1 lg:mr-64 p-6">{children}</main>
      </div>
    </ProtectedRoute>
  );
}
