<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <style>
    body {
      font-family: Arial, sans-serif;
      line-height: 1.6;
      color: #333;
    }

    .container {
      max-width: 600px;
      margin: 0 auto;
      padding: 20px;
    }

    .header {
      background-color: #4a5568;
      color: white;
      padding: 20px;
      text-align: center;
    }

    .content {
      padding: 20px;
      background-color: #f7fafc;
    }

    .credentials {
      background-color: white;
      border: 1px solid #e2e8f0;
      padding: 15px;
      margin: 20px 0;
      border-radius: 5px;
    }

    .credential-item {
      margin: 10px 0;
    }

    .credential-label {
      font-weight: bold;
      color: #4a5568;
    }

    .credential-value {
      font-family: monospace;
      background-color: #edf2f7;
      padding: 5px 10px;
      border-radius: 3px;
      display: inline-block;
    }

    .warning {
      background-color: #fff3cd;
      border-left: 4px solid #ffc107;
      padding: 10px;
      margin: 20px 0;
    }

    .footer {
      text-align: center;
      padding: 20px;
      color: #718096;
      font-size: 12px;
    }
  </style>
</head>

<body>
  <div class="container">
    <div class="header">
      <h1>Welcome to Youth Diplomacy Program</h1>
    </div>

    <div class="content">
      <p>Dear {{ $user->full_name }},</p>

      <p>Thank you for registering with the Youth Diplomacy Program. Your account has been successfully created.</p>

      <div class="credentials">
        <h3>Your Login Credentials</h3>
        <div class="credential-item">
          <span class="credential-label">Email:</span>
          <span class="credential-value">{{ $user->email }}</span>
        </div>
        <div class="credential-item">
          <span class="credential-label">Temporary Password:</span>
          <span class="credential-value">{{ $temporaryPassword }}</span>
        </div>
      </div>

      <div class="warning">
        <strong>⚠️ Important:</strong>
        <ul>
          <li>Please change your password after your first login</li>
          <li>Keep your credentials secure and do not share them</li>
          <li>You will be notified when the exam becomes available</li>
        </ul>
      </div>

      <p>You can login to your account at: <a href="{{ config('app.url') }}/login">{{ config('app.url') }}/login</a></p>

      <p>If you have any questions, please don't hesitate to contact us.</p>

      <p>Best regards,<br>Youth Diplomacy Program Team</p>
    </div>

    <div class="footer">
      <p>This is an automated email. Please do not reply to this message.</p>
    </div>
  </div>
</body>

</html>