<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GovernoratesSeeder extends Seeder
{
    public function run(): void
    {
        $governorates = [
            ['name_en' => 'Cairo', 'name_ar' => 'القاهرة', 'code' => 'C'],
            ['name_en' => 'Giza', 'name_ar' => 'الجيزة', 'code' => 'G'],
            ['name_en' => 'Alexandria', 'name_ar' => 'الإسكندرية', 'code' => 'ALX'],
            ['name_en' => 'Aswan', 'name_ar' => 'أسوان', 'code' => 'ASN'],
            ['name_en' => 'Asyut', 'name_ar' => 'أسيوط', 'code' => 'AST'],
            ['name_en' => 'Beheira', 'name_ar' => 'البحيرة', 'code' => 'BH'],
            ['name_en' => 'Beni Suef', 'name_ar' => 'بني سويف', 'code' => 'BS'],
            ['name_en' => 'Dakahlia', 'name_ar' => 'الدقهلية', 'code' => 'DK'],
            ['name_en' => 'Damietta', 'name_ar' => 'دمياط', 'code' => 'DM'],
            ['name_en' => 'Faiyum', 'name_ar' => 'الفيوم', 'code' => 'FY'],
            ['name_en' => 'Sharqia', 'name_ar' => 'الشرقية', 'code' => 'SHR'],
            ['name_en' => 'Gharbia', 'name_ar' => 'الغربية', 'code' => 'GHB'],
            ['name_en' => 'Ismailia', 'name_ar' => 'الإسماعيلية', 'code' => 'IS'],
            ['name_en' => 'Kafr El Sheikh', 'name_ar' => 'كفر الشيخ', 'code' => 'KS'],
            ['name_en' => 'Luxor', 'name_ar' => 'الأقصر', 'code' => 'LX'],
            ['name_en' => 'Matrouh', 'name_ar' => 'مرسى مطروح', 'code' => 'MT'],
            ['name_en' => 'Minya', 'name_ar' => 'المنيا', 'code' => 'MN'],
            ['name_en' => 'Monufia', 'name_ar' => 'المنوفية', 'code' => 'MF'],
            ['name_en' => 'New Valley', 'name_ar' => 'الوادي الجديد', 'code' => 'NV'],
            ['name_en' => 'North Sinai', 'name_ar' => 'شمال سيناء', 'code' => 'NS'],
            ['name_en' => 'Port Said', 'name_ar' => 'بورسعيد', 'code' => 'PS'],
            ['name_en' => 'Qalyubia', 'name_ar' => 'القليوبية', 'code' => 'QLY'],
            ['name_en' => 'Qena', 'name_ar' => 'قنا', 'code' => 'QN'],
            ['name_en' => 'Red Sea', 'name_ar' => 'البحر الأحمر', 'code' => 'RS'],
            ['name_en' => 'Sohag', 'name_ar' => 'سوهاج', 'code' => 'SHG'],
            ['name_en' => 'South Sinai', 'name_ar' => 'جنوب سيناء', 'code' => 'SS'],
            ['name_en' => 'Suez', 'name_ar' => 'السويس', 'code' => 'SW'],
        ];

        DB::table('governorates')->insert($governorates);
    }
}
