<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;

class CategorySeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    $categories = [
      [
        'name' => 'Technical Track',
        'description' => 'Candidates with technical and IT backgrounds',
      ],
      [
        'name' => 'Political Science Track',
        'description' => 'Candidates studying political science and international relations',
      ],
      [
        'name' => 'Business & Economics Track',
        'description' => 'Candidates in business, economics, and finance fields',
      ],
      [
        'name' => 'Arts & Humanities Track',
        'description' => 'Candidates from arts, literature, and humanities backgrounds',
      ],
      [
        'name' => 'Law Track',
        'description' => 'Candidates studying or practicing law',
      ],
      [
        'name' => 'Medical & Health Track',
        'description' => 'Candidates in medical and health sciences',
      ],
    ];

    foreach ($categories as $category) {
      Category::firstOrCreate(
        ['name' => $category['name']],
        ['description' => $category['description']]
      );
    }

    $this->command->info('Categories created successfully!');
  }
}
