<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;

class AdminSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    // Create Admin User
    User::firstOrCreate(
      ['email' => 'admin@eydp.gov'],
      [
        'password' => bcrypt('Admin-EYDP@123456'),
        'full_name' => 'System Administrator',
        'role' => 'admin',
        'is_active' => true,
      ]
    );

    // Create Sample Judge Users
    User::firstOrCreate(
      ['email' => 'judge1@eydp.gov'],
      [
        'password' => bcrypt('Judge1@123456'),
        'full_name' => 'Judge One',
        'role' => 'judge',
        'is_active' => true,
      ]
    );

    User::firstOrCreate(
      ['email' => 'judge2@eydp.gov'],
      [
        'password' => bcrypt('Judge@123456'),
        'full_name' => 'Judge Two',
        'role' => 'judge',
        'is_active' => true,
      ]
    );

    User::firstOrCreate(
      ['email' => 'judge3@eydp.gov'],
      [
        'password' => bcrypt('Judge@123456'),
        'full_name' => 'Judge Three',
        'role' => 'judge',
        'is_active' => true,
      ]
    );

    User::firstOrCreate(
      ['email' => 'judge4@eydp.gov'],
      [
        'password' => bcrypt('Judge@123456'),
        'full_name' => 'Judge Four',
        'role' => 'judge',
        'is_active' => true,
      ]
    );

    User::firstOrCreate(
      ['email' => 'judge5@eydp.gov'],
      [
        'password' => bcrypt('Judge@123456'),
        'full_name' => 'Judge Five',
        'role' => 'judge',
        'is_active' => true,
      ]
    );

    $this->command->info('Admin and Judge users created successfully!');
  }
}
