<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('applicant_submissions', function (Blueprint $table) {
      $table->id();
      $table->foreignId('applicant_id')->nullable()->constrained()->cascadeOnDelete();

      // Track submission origin
      $table->string('ip_address')->nullable();
      $table->string('browser_fingerprint')->nullable();
      $table->text('user_agent')->nullable();

      // Device info
      $table->string('device_type')->nullable(); // mobile, tablet, desktop
      $table->string('os')->nullable(); // Windows, macOS, iOS, Android, Linux
      $table->string('browser')->nullable(); // Chrome, Firefox, Safari, Edge

      $table->timestamps();

      // Indexes for fast lookups
      $table->index('ip_address');
      $table->index('browser_fingerprint');
      $table->index('created_at');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('applicant_submissions');
  }
};
