<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::table('applicants', function (Blueprint $table) {
      // Add status field with values: submitted, reviewed, rejected, accepted
      // Default is 'submitted'
      $table->enum('status', ['submitted', 'reviewed', 'rejected', 'accepted'])->default('submitted')->after('applicant_code');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::table('applicants', function (Blueprint $table) {
      $table->dropColumn('status');
    });
  }
};
