<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   * Add soft deletes to all tables that don't already have them
   */
  public function up(): void
  {
    // Users table
    if (Schema::hasTable('users') && !Schema::hasColumn('users', 'deleted_at')) {
      Schema::table('users', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Exams table
    if (Schema::hasTable('exams') && !Schema::hasColumn('exams', 'deleted_at')) {
      Schema::table('exams', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Exam attempts table
    if (Schema::hasTable('exam_attempts') && !Schema::hasColumn('exam_attempts', 'deleted_at')) {
      Schema::table('exam_attempts', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Evaluation sheets table
    if (Schema::hasTable('evaluation_sheets') && !Schema::hasColumn('evaluation_sheets', 'deleted_at')) {
      Schema::table('evaluation_sheets', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Evaluations table
    if (Schema::hasTable('evaluations') && !Schema::hasColumn('evaluations', 'deleted_at')) {
      Schema::table('evaluations', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Evaluation aggregates table
    if (Schema::hasTable('evaluation_aggregates') && !Schema::hasColumn('evaluation_aggregates', 'deleted_at')) {
      Schema::table('evaluation_aggregates', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Categories table
    if (Schema::hasTable('categories') && !Schema::hasColumn('categories', 'deleted_at')) {
      Schema::table('categories', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Category user pivot table
    if (Schema::hasTable('category_user') && !Schema::hasColumn('category_user', 'deleted_at')) {
      Schema::table('category_user', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Registrations table (if exists)
    if (Schema::hasTable('registrations') && !Schema::hasColumn('registrations', 'deleted_at')) {
      Schema::table('registrations', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Applicants table
    if (Schema::hasTable('applicants') && !Schema::hasColumn('applicants', 'deleted_at')) {
      Schema::table('applicants', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Applicant languages table
    if (Schema::hasTable('applicant_languages') && !Schema::hasColumn('applicant_languages', 'deleted_at')) {
      Schema::table('applicant_languages', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Applicant degrees table
    if (Schema::hasTable('applicant_degrees') && !Schema::hasColumn('applicant_degrees', 'deleted_at')) {
      Schema::table('applicant_degrees', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Applicant nationalities table
    if (Schema::hasTable('applicant_nationalities') && !Schema::hasColumn('applicant_nationalities', 'deleted_at')) {
      Schema::table('applicant_nationalities', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Applicant documents table
    if (Schema::hasTable('applicant_documents') && !Schema::hasColumn('applicant_documents', 'deleted_at')) {
      Schema::table('applicant_documents', function (Blueprint $table) {
        $table->softDeletes();
      });
    }

    // Settings table
    if (Schema::hasTable('settings') && !Schema::hasColumn('settings', 'deleted_at')) {
      Schema::table('settings', function (Blueprint $table) {
        $table->softDeletes();
      });
    }
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    // Drop soft delete columns from all tables
    $tables = [
      'users',
      'exams',
      'exam_attempts',
      'evaluation_sheets',
      'evaluations',
      'evaluation_aggregates',
      'categories',
      'category_user',
      'registrations',
      'applicants',
      'applicant_languages',
      'applicant_degrees',
      'applicant_nationalities',
      'applicant_documents',
      'settings',
    ];

    foreach ($tables as $table) {
      if (Schema::hasTable($table) && Schema::hasColumn($table, 'deleted_at')) {
        Schema::table($table, function (Blueprint $table) {
          $table->dropSoftDeletes();
        });
      }
    }
  }
};
