<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::table('system_logs', function (Blueprint $table) {
      $table->string('causer_type')->nullable()->change();
      $table->unsignedBigInteger('causer_id')->nullable()->change();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::table('system_logs', function (Blueprint $table) {
      $table->string('causer_type')->change();
      $table->unsignedBigInteger('causer_id')->change();
    });
  }
};
