<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('applicants', function (Blueprint $table) {
            $table->id();

            $table->string('full_name_ar');
            $table->string('full_name_en');

            $table->string('national_id', 14)->unique();
            $table->string('passport_number')->nullable();

            $table->string('applicant_code')->unique();

            $table->date('dob');
            $table->enum('gender', ['male', 'female']);
            $table->string('military_status')->nullable(); // only if male

            $table->string('mobile');
            $table->string('whatsapp')->nullable();
            $table->string('email')->unique();

            $table->string('address');
            $table->string('district');
            $table->foreignId('governorate_id')->constrained()->cascadeOnDelete();
            $table->string('birth_place');

            // Other Nationalities in applicant_nationalities table

            $table->string('degree');
            $table->string('major');
            $table->string('college');
            $table->string('university');

            $table->boolean('is_studying');
            $table->string('study_year')->nullable();
            $table->string('grad_year')->nullable();

            // Degrees in applicant_degrees table
            // Languages in applicant_languages table

            $table->string('current_job')->nullable();
            $table->string('employer')->nullable();

            // Long answers
            $table->longText('experience_public')->nullable();
            $table->longText('experience_ministry')->nullable();
            $table->longText('experience_other_orgs')->nullable();
            $table->longText('visited_countries')->nullable();
            $table->longText('center_memberships')->nullable();
            $table->longText('club_memberships')->nullable();
            $table->longText('sports')->nullable();
            $table->longText('skills_hobbies')->nullable();

            $table->longText('motivation')->nullable();
            $table->longText('strengths')->nullable();
            $table->longText('weaknesses')->nullable();

            // Documents in applicant_documents table

            // Social
            $table->string('facebook')->nullable();
            $table->string('instagram')->nullable();
            $table->string('linkedin')->nullable();

            $table->integer('height');
            $table->integer('weight');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('applicants');
    }
};
