<?php

namespace App\Observers;

use App\Models\Evaluation;
use App\Jobs\AggregateEvaluationScores;

class EvaluationObserver
{
    public function created(Evaluation $evaluation): void
    {
        $evaluationCount = Evaluation::where(
            'evaluated_user_id',
            $evaluation->evaluated_user_id
        )->count();

        if ($evaluationCount === 5) {
            AggregateEvaluationScores::dispatch($evaluation->evaluatedUser);
        }
    }
}
