<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class SystemLog extends Model
{
    protected $fillable = [
        'causer_type',
        'causer_id',
        'action',
        'subject_type',
        'subject_id',
        'meta',
        'ip_address',
        'user_agent',
    ];

    protected $casts = [
        'meta' => 'json',
    ];

    public const UPDATED_AT = null;

    /**
     * Get the causer (user who performed the action)
     */
    public function causer(): MorphTo
    {
        return $this->morphTo();
    }

    /**
     * Get the subject (entity that was acted upon)
     */
    public function subject(): MorphTo
    {
        return $this->morphTo();
    }
}
