<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExamAttempt extends Model
{
    use SoftDeletes;
    protected $fillable = [
        'exam_id',
        'user_id',
        'answers',
        'score',
        'started_at',
        'completed_at',
        'auto_submitted',
    ];

    protected $casts = [
        'answers' => 'json',
        'started_at' => 'datetime',
        'completed_at' => 'datetime',
        'auto_submitted' => 'boolean',
    ];

    public function exam(): BelongsTo
    {
        return $this->belongsTo(Exam::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
