<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class EvaluationSheet extends Model
{
    use SoftDeletes;
    protected $fillable = [
        'created_by',
        'title',
        'criteria',
        'is_active',
    ];

    protected $casts = [
        'criteria' => 'json',
        'is_active' => 'boolean',
    ];

    public function createdBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    // Backward compatibility alias
    public function judge(): BelongsTo
    {
        return $this->createdBy();
    }

    public function evaluations(): HasMany
    {
        return $this->hasMany(Evaluation::class);
    }
}
