<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApplicantLanguage extends Model
{
    use SoftDeletes;
    protected $fillable = ['applicant_id', 'language_id', 'proficiency'];

    public function applicant()
    {
        return $this->belongsTo(Applicant::class);
    }

    public function language()
    {
        return $this->belongsTo(Language::class);
    }
}
