<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Applicant extends Model
{
    use SoftDeletes;
    protected $fillable = [
        'user_id',
        'full_name_ar',
        'full_name_en',
        'national_id',
        'passport_number',
        'applicant_code',
        'dob',
        'gender',
        'military_status',
        'mobile',
        'whatsapp',
        'email',
        'address',
        'district',
        'governorate_id',
        'birth_place',
        'other_nationality',
        'degree',
        'major',
        'college',
        'university',
        'is_studying',
        'study_year',
        'grad_year',
        'current_job',
        'employer',
        'experience_public',
        'experience_ministry',
        'experience_other_orgs',
        'visited_countries',
        'center_memberships',
        'club_memberships',
        'sports',
        'skills_hobbies',
        'motivation',
        'strengths',
        'weaknesses',
        'facebook',
        'instagram',
        'linkedin',
        'height',
        'weight'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function governorate(): BelongsTo
    {
        return $this->belongsTo(Governorate::class);
    }

    public function nationalities(): HasMany
    {
        return $this->hasMany(ApplicantNationality::class);
    }

    public function languages(): HasMany
    {
        return $this->hasMany(ApplicantLanguage::class);
    }

    public function degrees(): HasMany
    {
        return $this->hasMany(ApplicantDegree::class);
    }

    public function documents(): HasMany
    {
        return $this->hasMany(ApplicantDocument::class);
    }
}
