<?php

namespace App\Listeners;

use App\Events\UserRegistered;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class SendRegistrationCredentials
{
  /**
   * Handle the event.
   */
  public function handle(UserRegistered $event): void
  {
    $user = $event->user;
    $registration = $event->registration;

    // Generate a temporary password or activation token
    $temporaryPassword = Str::random(12);
    $user->update(['password' => bcrypt($temporaryPassword)]);

    // Send email with login credentials
    try {
      Mail::to($user->email)->send(new \App\Mail\RegistrationCredentials($user, $temporaryPassword));

      Log::info('Registration credentials sent', [
        'user_id' => $user->id,
        'email' => $user->email,
      ]);
    } catch (\Exception $e) {
      Log::error('Failed to send registration credentials', [
        'user_id' => $user->id,
        'email' => $user->email,
        'error' => $e->getMessage(),
      ]);
    }
  }
}
