<?php

namespace App\Jobs;

use App\Models\User;
use App\Services\EvaluationService;
use App\Events\EvaluationAggregateCompleted;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class AggregateEvaluationScores implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public User $user,
    ) {}

    public function handle(EvaluationService $evaluationService): void
    {
        $aggregate = $evaluationService->aggregateEvaluations($this->user);

        event(new EvaluationAggregateCompleted(
            $this->user,
            $aggregate->toArray()
        ));
    }
}
