<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreRegistrationRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'form_id' => 'required|string|in:form_a,form_b',
            'national_id' => 'required|string|size:14|regex:/^[0-9]{14}$/',
            'fields' => 'required|array',
            'fields.full_name' => 'required|string|min:3|max:255',
            'fields.email' => 'required|email',
            'fields.password' => 'required|string|min:8',
            'fields.phone' => 'required|regex:/^[0-9+]{7,15}$/',
            'accept_terms' => 'required|boolean|accepted',
        ];
    }

    public function messages(): array
    {
        return [
            'national_id.regex' => 'National ID must be 14 digits',
            'fields.phone.regex' => 'Phone number format is invalid',
            'accept_terms.accepted' => 'You must accept the terms and conditions',
        ];
    }
}
