<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Setting;

class CheckMaintenanceMode
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $maintenanceMode = Setting::get('maintenance_mode', false);

        // Allow admin users to bypass maintenance mode
        $user = $request->user();
        if ($maintenanceMode && (!$user || $user->role !== 'admin')) {
            return response()->json([
                'status' => false,
                'message' => 'النظام في وضع الصيانة حالياً',
                'maintenance_mode' => true,
            ], 503);
        }

        return $next($request);
    }
}
