<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreRegistrationRequest;
use App\Http\Requests\AutosaveRegistrationRequest;
use App\Services\RegistrationService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RegistrationController extends Controller
{
    public function store(
        StoreRegistrationRequest $request,
        RegistrationService $registrationService
    ) {
        $registration = $registrationService->createRegistration($request->validated());

        return response()->json([
            'success' => true,
            'data' => [
                'registration_id' => $registration->id,
                'user_id' => $registration->user_id,
                'message' => 'Registration submitted successfully',
            ],
        ], 201);
    }

    public function autosave(
        AutosaveRegistrationRequest $request,
        RegistrationService $registrationService
    ) {
        $registrationService->autosaveDraft(
            Auth::user(),
            $request->input('form_id'),
            $request->input('fields')
        );

        return response()->json([
            'success' => true,
            'data' => ['message' => 'Draft saved'],
        ]);
    }
}
