<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Services\SpecYearService;
use Illuminate\Http\Request;

class IdentifyController extends Controller
{
    public function __invoke(Request $request, SpecYearService $specYearService)
    {
        $validated = $request->validate([
            'national_id' => 'required|string|size:14|regex:/^[0-9]{14}$/',
        ]);

        $result = $specYearService->determineFormByNationalId($validated['national_id']);

        return response()->json([
            'success' => true,
            'data' => $result,
        ]);
    }
}
